﻿using UnityEngine;

public class CoordinateMapper : MonoBehaviour
{
    public Vector3 WorldOrigin { get; set; }
    public Vector3 GraphOrigin { get; set; }
    public float GraphScale { get; set; } = 1f;

    // Modelspace → Worldspace
    public Vector3 ToWorld(Vector3 modelspace)
    {
        return WorldOrigin + (modelspace - GraphOrigin) * GraphScale;
    }

    // Worldspace → Modelspace
    public Vector3 ToModel(Vector3 worldspace)
    {
        return GraphOrigin + (worldspace - WorldOrigin) / GraphScale;
    }

    public override string ToString()
    {
        return $"CoordinateMapper, WorldOrigin: {WorldOrigin}, GraphOrigin: {GraphOrigin}, GraphScale: {GraphScale}";
    }
}
